-- PyrosparkCore - Server Functions
-- Exported server functions for use by other resources

-- ============================================================================
--                          EXPORTED FUNCTIONS
-- ============================================================================

-- Get player identifiers
-- Usage: local identifiers = exports['PS-PyrosparkCore']:GetPlayerIdentifiers(source)
-- Returns: table of identifier strings
exports('GetPlayerIdentifiers', function(source)
    return GetPlayerIdentifiers(source)
end)

-- Get specific identifier type
-- Usage: local steam = exports['PS-PyrosparkCore']:GetPlayerIdentifier(source, 'steam')
-- Params: source (player id), identifierType (steam, license, discord, etc.)
-- Returns: string or nil
exports('GetPlayerIdentifier', function(source, identifierType)
    local identifiers = GetPlayerIdentifiers(source)

    for _, identifier in ipairs(identifiers) do
        if string.match(identifier, identifierType .. ':') then
            return identifier
        end
    end

    return nil
end)

-- Check if player is admin
-- Usage: local isAdmin = exports['PS-PyrosparkCore']:IsPlayerAdmin(source)
-- Returns: boolean
exports('IsPlayerAdmin', function(source)
    -- Check ACE permission
    if IsPlayerAceAllowed(source, Config.AdminPermission) then
        return true
    end

    -- Check admin list if enabled
    if Config.UseAdminList then
        local identifiers = GetPlayerIdentifiers(source)
        for _, identifier in ipairs(identifiers) do
            for _, adminId in ipairs(Config.AdminList) do
                if identifier == adminId then
                    return true
                end
            end
        end
    end

    return false
end)

-- Get all online players
-- Usage: local players = exports['PS-PyrosparkCore']:GetOnlinePlayers()
-- Returns: table of player sources
exports('GetOnlinePlayers', function()
    local players = {}
    for _, playerId in ipairs(GetPlayers()) do
        table.insert(players, tonumber(playerId))
    end
    return players
end)

-- Get player name by source
-- Usage: local name = exports['PS-PyrosparkCore']:GetPlayerName(source)
-- Returns: string
exports('GetPlayerName', function(source)
    return GetPlayerName(source)
end)
